
#include "stm32f10x_lib.h"
#include "stm32f10x_usart.h"


#include "USART.h"

void Delay10us(vu32 nCount);
void Open_Usart1(void);

void Open_Usart1(void)
{
  NVIC_InitTypeDef NVIC_InitStructure;
  GPIO_InitTypeDef GPIO_InitStructure;
  int i;
  
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1|RCC_APB2Periph_GPIOA | RCC_APB2Periph_TIM1, ENABLE);      
  /* enabling USART1 interrupt */
  NVIC_InitStructure.NVIC_IRQChannel=USART1_IRQChannel;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  // Configure USART1 Tx (PA.09) as alternate function push-pull //
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  // Configure USART1 Rx (PA.10) as input floating //
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(GPIOA, &GPIO_InitStructure); 
  USART1_Configuration();
  
}

void Delay10us(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}


void USART1_SendByte(u16 Data)
{ 
   while (!(USART1->SR & USART_FLAG_TXE));
   USART1->DR =(Data & (u16)0x01FF);	
   
}
void USART1Write(u8* data,u16 len)
{
	u16 i;
	//DIR485_H ;
	for (i=0; i<len; i++){
		USART1_SendByte(data[i]);
	}
	//Delay10us(1000);
	//DIR485_L;		
}	
void USART1_Configuration(void)
{
	
	USART_InitTypeDef USART_InitStructure;
	
	USART_InitStructure.USART_BaudRate= 9600;
	USART_StructInit(&USART_InitStructure);
	USART_Init(USART1, &USART_InitStructure);
	USART_ITConfig(USART1, USART_IT_RXNE, ENABLE);
	USART_Cmd(USART1, ENABLE);     
/*	DIR485_L;  */
}

void U1_IRQHandler(void)
{
	u8 c;
	if(USART_GetITStatus(USART1, USART_IT_RXNE) != RESET)
	{ 	
	    c=USART1->DR;
		USART1_SendByte(c); 	    
	} 
	 
}

void USART2_SendByte(u16 Data)
{ 
   while (!(USART2->SR & USART_FLAG_TXE));
   USART2->DR =(Data & (u16)0x01FF);	 
   
}

void USART2Write(u8* data,u16 len)
{
	u16 i;
//	DIR485_H ;
	for (i=0; i<len; i++){
		USART2_SendByte(data[i]);
         // USART_SendData(USART2,data[i]);
        }
//	Delay10us(1000);//
//	DIR485_L;		
}	

void USART2_Configuration(void)
{
	USART_InitTypeDef USART_InitStructure;
	
	USART_InitStructure.USART_BaudRate= 115200;
	USART_StructInit(&USART_InitStructure);
	USART_Init(USART2, &USART_InitStructure);
	USART_ITConfig(USART2, USART_IT_RXNE, ENABLE);
	USART_Cmd(USART2, ENABLE);     
/*	DIR485_L;  */
}


void U2_IRQHandler(void)
{
	u8 c;
	if(USART_GetITStatus(USART2, USART_IT_RXNE) != RESET)
	{ 	
	    c=USART2->DR;
		USART2_SendByte(c); 	    
	} 
	 
}




